/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.framework.DrawingView;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.action.ActionFactory;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.pdraw.action.ReplaceBlocksAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import DE.siemens.ad.pdraw.simulation.SimulationTool;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFBlockFigure;
import DE.siemens.ad.udf.UDFFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class UpdateUDFAction
extends LogoAction {
    private static final long serialVersionUID = 8274401335768334680L;
    private List<UDFBlockFigure> figures;

    public UpdateUDFAction() {
        this.putValue("Name", "update udfs");
        this.putValue("textKey", "pdraw.standard.updateUDFs");
        this.putValue("ShortDescription", Language.getStringNoTilde("pdraw.standard.updateUDFs", "update UDF"));
        this.disabledContextVector = new Vector(2);
        this.disabledContextVector.add(SimulationTool.class);
        this.disabledContextVector.add(OnlineTestTool.class);
    }

    public boolean doIt() {
        ArrayList<UDFBlock> noInfo = new ArrayList<UDFBlock>();
        HashMap<Long, Long> updatedGuidMap = new HashMap<Long, Long>();
        ArrayList<UDFBlock> noNeedToUpdate = new ArrayList<UDFBlock>();
        ArrayList<UDFBlockFigure> tobeUpdated = new ArrayList<UDFBlockFigure>();
        for (UDFBlockFigure figure : this.figures) {
            UDFBlock block = (UDFBlock)figure.getBlock();
            long guid = block.getGuid();
            block.setState(UDFFactory.instance().getUDFBlockState(guid));
            switch (block.getState()) {
                case 0: {
                    noNeedToUpdate.add(block);
                    break;
                }
                case 2: {
                    noInfo.add(block);
                    break;
                }
                case 1: {
                    if (updatedGuidMap.containsKey(guid)) {
                        tobeUpdated.add(figure);
                        break;
                    }
                    long newGuid = UDFFactory.instance().getLatestGuid(guid);
                    if (newGuid == 0L) {
                        System.err.println("Error! info should exist!");
                        break;
                    }
                    updatedGuidMap.put(guid, newGuid);
                    tobeUpdated.add(figure);
                }
            }
        }
        if (noNeedToUpdate.size() > 0) {
            Log.print("Latest UDFs: ");
            for (UDFBlock blk : noNeedToUpdate) {
                Log.print(blk.getNumberString() + " ");
            }
            Log.println("");
        }
        if (noInfo.size() > 0) {
            Log.print("UDF whose library is not configured: ");
            for (UDFBlock blk : noInfo) {
                Log.print(blk.getNumberString() + " ");
            }
            Log.println("");
        }
        ActionFactory actionFactory = ((Editor)((Object)this.getDrawingView().editor())).getActionManager().getActionFactory();
        ReplaceBlocksAction compositeActions = (ReplaceBlocksAction)actionFactory.getAction("DE.siemens.ad.pdraw.action.ReplaceBlocksAction");
        for (UDFBlockFigure figure : tobeUpdated) {
            long newGuid = (Long)updatedGuidMap.get(((UDFBlock)figure.getBlock()).getGuid());
            UDFBlock newBlock = UDFFactory.instance().getUDFBlock(figure.getBlock().getWiringDiagram(), newGuid);
            if (newBlock.getValidity() != 0) {
                Log.println(figure.getBlock().getNumberString() + " [" + ((UDFBlock)figure.getBlock()).getVersion() + "] not updated: latest is not validate.");
                continue;
            }
            newBlock.setNumber(figure.getBlock().getNumber());
            UDFBlockFigure newUDFFigure = new UDFBlockFigure(newBlock, figure.getImageFigure().displayBox().getLocation());
            compositeActions.setBlockFigures(figure, newUDFFigure);
            if (!((Editor)((Object)this.getDrawingView().editor())).getActionManager().invokeAction(compositeActions)) continue;
            Log.println(figure.getBlock().getNumberString() + " [" + ((UDFBlock)figure.getBlock()).getVersion() + " -> " + ((UDFBlock)newUDFFigure.getBlock()).getVersion() + "]");
        }
        return true;
    }

    public boolean prepareAction() {
        this.figures = new ArrayList<UDFBlockFigure>();
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        Vector vect = view.selection();
        for (Object o : vect) {
            if (!(o instanceof UDFBlockFigure)) continue;
            this.figures.add((UDFBlockFigure)o);
        }
        return this.figures.size() > 0;
    }
}

